from django.contrib.auth.decorators import user_passes_test
from django.http import HttpResponse, HttpResponseRedirect
from django.urls import reverse
from django.shortcuts import get_object_or_404, render
from blog.forms import BlogPostForm

from blog.models import BlogPost


def blog_posts(request):
    posts = BlogPost.objects.all()

    return render(request, "blog/index.html", context={"posts": posts})


def blog_post(request, slug):
    post = BlogPost.objects.get(slug=slug)

    return render(request, "blog/post.html", context={"post": post})

def blog_post_create(request):
    if request.method == "POST":
        form = BlogPostForm(request.POST)
        if form.is_valid():
            form.instance.published = True
            if request.user.is_authenticated:
                form.instance.author = request.user
            form.save()
            return HttpResponseRedirect(reverse("blog-index"))
    else:
        form = BlogPostForm()

    return render(request, "blog/create_post.html", {"form": form})